"""Common filenames and locations for topographic data, meshes and outputs.
"""

from os import sep, environ, getenv, getcwd
from os.path import expanduser
import sys
from time import localtime, strftime, gmtime
from anuga.utilities.polygon import read_polygon, plot_polygons, polygon_area, is_inside_polygon, number_mesh_triangles
from anuga.coordinate_transforms.redfearn import degminsec2decimal_degrees, convert_from_latlon_to_utm
from anuga.utilities.system_tools import get_user_name

# file and system info
#---------------------------------
codename = 'project.py'

home = getenv('INUNDATIONHOME') #Sandpit's parent dir   
user = get_user_name()

# INUNDATIONHOME is the inundation directory, not the data directory.
home += sep +'data'

#time stuff
time = strftime('%Y%m%d_%H%M%S',localtime()) #gets time for new dir
gtime = strftime('%Y%m%d_%H%M%S',gmtime()) #gets time for new dir
build_time = time+'_build'
run_time = time+'_run'
temp_time = time+'_temp'
print 'gtime: ', gtime

#tide = -2.5
#tide = 0.0
tide = 2.4

#Making assumptions about the location of scenario data
state = 'western_australia'
scenario_name = 'dampier'
scenario = 'dampier_tsunami_scenario_2006'

# onshore data provided by WA DLI
onshore_name = 'DLI_DTED_raster_clipped' # original

# AHO + DPI data + colin French coastline
coast_name = 'coastline_edited_w_DEM'
offshore_name = 'clipped_bathy'
offshore1_name = 'elev_501'
offshore2_name = 'inferrec_e'

#final topo name
combined_name ='dampier_combined_elevation'
combined_smaller_name = 'dampier_combined_elevation_small'
combined_smallest_name = 'dampier_combined_elevation_smallest'

topographies_in_dir = home+sep+state+sep+scenario+sep+'elevation_final'+sep+'070112'+sep+'points'+sep
topographies_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'topographies'+sep
topographies_time_dir = topographies_dir+build_time+sep

temp_dir = home+sep+state+sep+scenario+sep+'anuga'+sep
temp_dir_name = temp_dir + temp_time+sep

# input topo file location
onshore_in_dir_name = topographies_in_dir + onshore_name
coast_in_dir_name = topographies_in_dir + coast_name
offshore_in_dir_name = topographies_in_dir + offshore_name
offshore1_in_dir_name = topographies_in_dir + offshore1_name
offshore2_in_dir_name = topographies_in_dir + offshore2_name

onshore_dir_name = topographies_dir + onshore_name
coast_dir_name = topographies_dir + coast_name
offshore_dir_name = topographies_dir + offshore_name
offshore1_dir_name = topographies_dir + offshore1_name
offshore2_dir_name = topographies_dir + offshore2_name

#final topo files
combined_dir_name = topographies_dir + combined_name
combined_time_dir_name = topographies_time_dir + combined_name
combined_smaller_dir_name = topographies_dir + combined_smaller_name
combined_smallest_dir_name = topographies_dir + combined_smallest_name
#combined_time_dir_final_name = topographies_time_dir + combined_final_name

meshes_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'meshes'+sep
meshes_dir_name = meshes_dir + scenario_name

polygons_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'polygons'+sep+'2007polys'+sep
tide_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'tide_data'+sep

boundaries_source = ''
boundaries_name = 'o'
boundaries_name1 = 'o_new1'
boundaries_name2 = 'o_test'

#boundaries locations
#boundaries_in_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'boundaries'+sep
boundaries_in_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'boundaries'+sep+'urs'+sep+'1_10000'+sep
boundaries_in_dir_name = boundaries_in_dir + boundaries_name
boundaries_in_dir2 = home+sep+state+sep+scenario+sep+'anuga'+sep+'boundaries'+sep+'urs'+sep+'ungridded'+sep
boundaries_in_dir_name2 = boundaries_in_dir2 + boundaries_name
boundaries_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'boundaries'+sep
boundaries_dir_name = boundaries_dir + boundaries_name
boundaries_dir_namea = boundaries_dir + boundaries_name+'_5000_35000'
boundaries_dir_name1 = boundaries_dir + boundaries_name1
boundaries_dir_name2 = boundaries_dir + boundaries_name2
boundaries_dir_name3 = boundaries_dir + boundaries_name+'_test_8500_12000'
boundaries_dir_name4 = boundaries_dir + boundaries_name+'_8500_12000_no_zone'
boundaries_dir_name5 = boundaries_dir + '20061026_173920_build'+sep+'dampier'
boundaries_dir_name6 = boundaries_dir + 'SU-AU'

#boundaries_time_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'boundaries'+sep+build_time+sep
#boundaries_time_dir_name = boundaries_time_dir + boundaries_name  #Used by post processing

#output locations
output_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'outputs'+sep
output_build_time_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'outputs'+sep+build_time+sep
output_run_time_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'outputs'+sep+run_time+sep
output_run_time_dir_name = output_run_time_dir + scenario_name  #Used by post processing

#gauges
gauge_name = 'dampier_gauges_up2.csv' #'dampier.csv'
gauge_name_simple = 'dampier_gauges_simple.csv' 
gauge_name_test = 'dampier_gauges_up_test.csv' #'dampier.csv'
gauges_dir = home+sep+state+sep+scenario+sep+'anuga'+sep+'gauges'+sep
gauges_dir_name = gauges_dir + gauge_name
gauges_dir_name_simple = gauges_dir + gauge_name_simple
gauges_dir_name_test = gauges_dir + gauge_name_test


#buildings_filename = gauges_dir + 'dampier_res_nexis.csv'
buildings_filename_damage_out = 'dampier_res_nexis_modified.csv'
###############################
# Domain definitions
###############################

refzone = 50 
south_boundary = degminsec2decimal_degrees(-20,58,0)
#north_boundary = degminsec2decimal_degrees(-20,13,0)
north_boundary = degminsec2decimal_degrees(-19,30,0)
west_boundary = degminsec2decimal_degrees(116,15,0)
east_boundary = degminsec2decimal_degrees(117,11,0)
##
##p0 = [south, degminsec2decimal_degrees(116,32,0)]
##p1 = [south, west]
##p2 = [degminsec2decimal_degrees(-20,23,0), west]
##p3 = [north, degminsec2decimal_degrees(116,45,0)]
##p4 = [north, degminsec2decimal_degrees(117,0,0)]
##p5 = [p2[0], degminsec2decimal_degrees(117,8,0)]
##p6 = [degminsec2decimal_degrees(-20,30,0), east]
##p7 = [degminsec2decimal_degrees(-20,38,0), east]
##p8 = [south, east]
##
##poly_all, zone = convert_from_latlon_to_utm([p0, p1, p2, p3, p4, p5, p6, p7, p8])
##refzone = zone
poly_all = read_polygon(polygons_dir+'extent.csv')
print 'Area of bounding polygon', polygon_area(poly_all)/1000000.0

res_factor = 1
res_poly_all = 150000*res_factor

###############################
# Interior region definitions
###############################

poly_region = read_polygon(polygons_dir+'region.csv')
res_region = 50000*res_factor

poly_dampier = read_polygon(polygons_dir+'dampier_town.csv')
res_dampier = 500*res_factor

poly_karratha = read_polygon(polygons_dir+'karrathav2.csv')
res_karratha = 15000*res_factor

poly_karratha_town = read_polygon(polygons_dir+'karratha_townv2.csv')
res_karratha_town = 500*res_factor

poly_facility = read_polygon(polygons_dir+'facility.csv')
res_facility = 1000*res_factor

poly_delambre = read_polygon(polygons_dir+'delambre.csv')
res_delambre = 1000*res_factor

poly_coast = read_polygon(polygons_dir+'coastpoly.csv')
res_coast = 5000*res_factor

poly_NWislands = read_polygon(polygons_dir+'nw_islands_area.csv')
res_NWislands = 50000*res_factor

poly_island0 = read_polygon(polygons_dir+'island0.csv')
res_island0 = res_poly_all

poly_island1 = read_polygon(polygons_dir+'island1.csv')
res_island0 = res_poly_all

poly_island2 = read_polygon(polygons_dir+'island2.csv')
res_island0 = res_poly_all

poly_island3 = read_polygon(polygons_dir+'island3.csv')
res_island0 = res_poly_all

res_islands = 5000*res_factor

poly_ref_nw4 = read_polygon(polygons_dir+'ref_nw4.csv')
res_ref_nw4 = res_islands

poly_island4 = read_polygon(polygons_dir+'island4.csv')
res_island0 = res_poly_all

poly_ref_nw5 = read_polygon(polygons_dir+'ref_nw5.csv')
res_ref_nw5 = res_islands

poly_island5 = read_polygon(polygons_dir+'island5.csv')
res_island0 = res_poly_all

poly_ref_nw6 = read_polygon(polygons_dir+'ref_nw6.csv')
res_ref_nw6 = res_islands

poly_island6 = read_polygon(polygons_dir+'island6.csv')
res_island0 = res_poly_all

poly_ref_nw7 = read_polygon(polygons_dir+'ref_nw7.csv')
res_ref_nw7 = res_islands

poly_island7 = read_polygon(polygons_dir+'island7.csv')
res_island0 = res_poly_all

poly_ref_nw8 = read_polygon(polygons_dir+'ref_nw8.csv')
res_ref_nw8 = res_islands

poly_island8 = read_polygon(polygons_dir+'island8.csv')
res_island0 = res_poly_all


#plot_polygons([poly_dampier,poly_karratha,poly_karratha_town,poly_delambre,
#                poly_coast,poly_NWislands,poly_island0,poly_island1,poly_island2,
#                poly_island3,poly_island4,poly_island5,poly_island6,
#                poly_island7,poly_island8,poly_ref_nw4,poly_ref_nw5,
#                poly_ref_nw6,poly_ref_nw7,poly_ref_nw8,poly_all],'poly_pic')

interior_regions = [[poly_dampier,res_dampier], 
                    [poly_karratha,res_karratha],[poly_karratha_town,res_karratha_town],
                    [poly_delambre,res_delambre],[poly_coast,res_coast],
                    [poly_facility,res_facility],
                    #[poly_NWislands,res_NWislands],
                    [poly_island0,res_island0],[poly_island1,res_island0],
                    [poly_island2,res_island0],[poly_island3,res_island0],
                    [poly_island4,res_island0],[poly_island5,res_island0],
                    [poly_island6,res_island0],[poly_island7,res_island0],
                    [poly_island8,res_island0],[poly_ref_nw4,res_ref_nw4],
                    [poly_ref_nw5,res_ref_nw5],[poly_ref_nw6,res_ref_nw6],
                    [poly_ref_nw7,res_ref_nw7],[poly_ref_nw8,res_ref_nw8]]

interior_regions_test = [[poly_dampier,res_dampier], 
                    [poly_karratha,res_karratha],[poly_karratha_town,res_karratha_town]]

trigs_min = number_mesh_triangles(interior_regions, poly_all, res_poly_all)

print 'min number triangles', trigs_min

###################################################################
# Clipping regions for export to asc and regions for clipping data
###################################################################

poly_mainland = read_polygon(polygons_dir+'mainland_only.csv')

# exporting asc grid - Dampier
e_min_area = 474000
e_max_area = 480000
n_min_area = 7719000
n_max_area = 7725000

